package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.VoiceConnectorName
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorRequest(
    name: VoiceConnectorName,
    awsRegion: Optional[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion] =
      Optional.Absent,
    requireEncryption: Boolean,
    tags: Optional[Iterable[zio.aws.chimesdkvoice.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest = {
    import CreateVoiceConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest
      .builder()
      .name(VoiceConnectorName.unwrap(name): java.lang.String)
      .optionallyWith(awsRegion.map(value => value.unwrap))(_.awsRegion)
      .requireEncryption(requireEncryption: java.lang.Boolean)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateVoiceConnectorRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateVoiceConnectorRequest
      .wrap(buildAwsValue())
}
object CreateVoiceConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateVoiceConnectorRequest =
      zio.aws.chimesdkvoice.model.CreateVoiceConnectorRequest(
        name,
        awsRegion.map(value => value),
        requireEncryption,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: VoiceConnectorName
    def awsRegion: Optional[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion]
    def requireEncryption: Boolean
    def tags: Optional[List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, VoiceConnectorName] = ZIO.succeed(name)
    def getAwsRegion: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion
    ] = AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getRequireEncryption: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(requireEncryption)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest
  ) extends zio.aws.chimesdkvoice.model.CreateVoiceConnectorRequest.ReadOnly {
    override val name: VoiceConnectorName =
      zio.aws.chimesdkvoice.model.primitives.VoiceConnectorName(impl.name())
    override val awsRegion
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsRegion())
        .map(value =>
          zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion.wrap(value)
        )
    override val requireEncryption: Boolean = impl.requireEncryption(): Boolean
    override val tags
        : Optional[List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest
  ): zio.aws.chimesdkvoice.model.CreateVoiceConnectorRequest.ReadOnly =
    new Wrapper(impl)
}
