package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  NonEmptyString256,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class CallDetails(
    voiceConnectorId: Optional[NonEmptyString128] = Optional.Absent,
    transactionId: Optional[NonEmptyString256] = Optional.Absent,
    isCaller: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CallDetails = {
    import CallDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CallDetails
      .builder()
      .optionallyWith(
        voiceConnectorId.map(value =>
          NonEmptyString128.unwrap(value): java.lang.String
        )
      )(_.voiceConnectorId)
      .optionallyWith(
        transactionId.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .optionallyWith(isCaller.map(value => value: java.lang.Boolean))(
        _.isCaller
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.CallDetails.ReadOnly =
    zio.aws.chimesdkvoice.model.CallDetails.wrap(buildAwsValue())
}
object CallDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CallDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CallDetails =
      zio.aws.chimesdkvoice.model.CallDetails(
        voiceConnectorId.map(value => value),
        transactionId.map(value => value),
        isCaller.map(value => value)
      )
    def voiceConnectorId: Optional[NonEmptyString128]
    def transactionId: Optional[NonEmptyString256]
    def isCaller: Optional[Boolean]
    def getVoiceConnectorId: ZIO[Any, AwsError, NonEmptyString128] =
      AwsError.unwrapOptionField("voiceConnectorId", voiceConnectorId)
    def getTransactionId: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getIsCaller: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCaller", isCaller)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CallDetails
  ) extends zio.aws.chimesdkvoice.model.CallDetails.ReadOnly {
    override val voiceConnectorId: Optional[NonEmptyString128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString128(value)
        )
    override val transactionId: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
    override val isCaller: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isCaller())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CallDetails
  ): zio.aws.chimesdkvoice.model.CallDetails.ReadOnly = new Wrapper(impl)
}
