package zio.aws.chimesdkvoice
import zio.aws.chimesdkvoice.model.GetSipRuleResponse.ReadOnly
import zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber
import zio.aws.chimesdkvoice.model.{
  CreateVoiceConnectorGroupRequest,
  UpdateVoiceConnectorRequest,
  GetVoiceConnectorOriginationRequest,
  UpdatePhoneNumberSettingsRequest,
  CreateVoiceConnectorRequest,
  GetProxySessionRequest,
  DeleteSipMediaApplicationRequest,
  StartVoiceToneAnalysisTaskRequest,
  ListVoiceConnectorTerminationCredentialsRequest,
  UpdateGlobalSettingsRequest,
  PutVoiceConnectorLoggingConfigurationRequest,
  UpdateSipMediaApplicationRequest,
  DeleteVoiceConnectorOriginationRequest,
  SearchAvailablePhoneNumbersRequest,
  GetVoiceConnectorProxyRequest,
  UpdateSipMediaApplicationCallRequest,
  StopSpeakerSearchTaskRequest,
  DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
  GetVoiceConnectorLoggingConfigurationRequest,
  GetSipRuleRequest,
  CreateSipMediaApplicationRequest,
  AssociatePhoneNumbersWithVoiceConnectorRequest,
  AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
  CreateProxySessionRequest,
  DeleteVoiceConnectorTerminationRequest,
  CreateVoiceProfileRequest,
  DeleteVoiceConnectorProxyRequest,
  UpdatePhoneNumberRequest,
  GetVoiceConnectorRequest,
  ListTagsForResourceRequest,
  CreatePhoneNumberOrderRequest,
  CreateVoiceProfileDomainRequest,
  PutSipMediaApplicationLoggingConfigurationRequest,
  PutVoiceConnectorOriginationRequest,
  ListVoiceConnectorGroupsRequest,
  PutVoiceConnectorTerminationRequest,
  GetVoiceConnectorGroupRequest,
  StartSpeakerSearchTaskRequest,
  DeletePhoneNumberRequest,
  DeleteProxySessionRequest,
  UpdateProxySessionRequest,
  BatchDeletePhoneNumberRequest,
  ListSipRulesRequest,
  ListProxySessionsRequest,
  DeleteVoiceConnectorGroupRequest,
  ListVoiceProfileDomainsRequest,
  ListPhoneNumbersRequest,
  PutSipMediaApplicationAlexaSkillConfigurationRequest,
  DeleteVoiceConnectorRequest,
  GetPhoneNumberOrderRequest,
  CreateSipRuleRequest,
  PutVoiceConnectorTerminationCredentialsRequest,
  DeleteVoiceConnectorTerminationCredentialsRequest,
  GetSipMediaApplicationRequest,
  DeleteVoiceConnectorStreamingConfigurationRequest,
  PutVoiceConnectorStreamingConfigurationRequest,
  DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
  PutVoiceConnectorEmergencyCallingConfigurationRequest,
  GetPhoneNumberRequest,
  StopVoiceToneAnalysisTaskRequest,
  GetVoiceProfileDomainRequest,
  ValidateE911AddressRequest,
  UpdateVoiceConnectorGroupRequest,
  UntagResourceRequest,
  CreateSipMediaApplicationCallRequest,
  GetSipMediaApplicationLoggingConfigurationRequest,
  UpdateVoiceProfileDomainRequest,
  RestorePhoneNumberRequest,
  ListSupportedPhoneNumberCountriesRequest,
  DeleteVoiceProfileRequest,
  GetVoiceProfileRequest,
  UpdateSipRuleRequest,
  DeleteVoiceProfileDomainRequest,
  UpdateVoiceProfileRequest,
  ListVoiceProfilesRequest,
  ListSipMediaApplicationsRequest,
  GetSpeakerSearchTaskRequest,
  DeleteSipRuleRequest,
  ListVoiceConnectorsRequest,
  GetVoiceConnectorTerminationHealthRequest,
  GetVoiceConnectorStreamingConfigurationRequest,
  BatchUpdatePhoneNumberRequest,
  GetVoiceConnectorEmergencyCallingConfigurationRequest,
  GetVoiceConnectorTerminationRequest,
  GetSipMediaApplicationAlexaSkillConfigurationRequest,
  ListPhoneNumberOrdersRequest,
  PutVoiceConnectorProxyRequest,
  TagResourceRequest,
  GetVoiceToneAnalysisTaskRequest,
  DisassociatePhoneNumbersFromVoiceConnectorRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ChimeSdkVoiceMock extends Mock[ChimeSdkVoice] {
  object ListSipMediaApplications
      extends Stream[
        ListSipMediaApplicationsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
      ]
  object ListSipMediaApplicationsPaginated
      extends Effect[
        ListSipMediaApplicationsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly
      ]
  object DeleteVoiceProfile
      extends Effect[DeleteVoiceProfileRequest, AwsError, Unit]
  object PutVoiceConnectorEmergencyCallingConfiguration
      extends Effect[
        PutVoiceConnectorEmergencyCallingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
      ]
  object DeleteSipRule extends Effect[DeleteSipRuleRequest, AwsError, Unit]
  object PutVoiceConnectorProxy
      extends Effect[
        PutVoiceConnectorProxyRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly
      ]
  object CreateVoiceConnector
      extends Effect[
        CreateVoiceConnectorRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateVoiceConnectorResponse.ReadOnly
      ]
  object RestorePhoneNumber
      extends Effect[
        RestorePhoneNumberRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly
      ]
  object PutSipMediaApplicationLoggingConfiguration
      extends Effect[
        PutSipMediaApplicationLoggingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
      ]
  object GetVoiceConnector
      extends Effect[
        GetVoiceConnectorRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly
      ]
  object DisassociatePhoneNumbersFromVoiceConnector
      extends Effect[
        DisassociatePhoneNumbersFromVoiceConnectorRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
      ]
  object UpdateVoiceConnectorGroup
      extends Effect[
        UpdateVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly
      ]
  object ListSupportedPhoneNumberCountries
      extends Effect[
        ListSupportedPhoneNumberCountriesRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
      ]
  object GetVoiceConnectorProxy
      extends Effect[
        GetVoiceConnectorProxyRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly
      ]
  object ListVoiceConnectors
      extends Stream[
        ListVoiceConnectorsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
      ]
  object ListVoiceConnectorsPaginated
      extends Effect[
        ListVoiceConnectorsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly
      ]
  object CreateVoiceProfileDomain
      extends Effect[
        CreateVoiceProfileDomainRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainResponse.ReadOnly
      ]
  object GetVoiceToneAnalysisTask
      extends Effect[
        GetVoiceToneAnalysisTaskRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly
      ]
  object UpdateSipRule
      extends Effect[
        UpdateSipRuleRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateSipRuleResponse.ReadOnly
      ]
  object ListAvailableVoiceConnectorRegions
      extends Effect[
        Unit,
        AwsError,
        zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly
      ]
  object GetVoiceConnectorTermination
      extends Effect[
        GetVoiceConnectorTerminationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationResponse.ReadOnly
      ]
  object AssociatePhoneNumbersWithVoiceConnector
      extends Effect[
        AssociatePhoneNumbersWithVoiceConnectorRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
      ]
  object CreatePhoneNumberOrder
      extends Effect[
        CreatePhoneNumberOrderRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly
      ]
  object DeleteVoiceConnectorEmergencyCallingConfiguration
      extends Effect[
        DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
        AwsError,
        Unit
      ]
  object GetSipMediaApplicationLoggingConfiguration
      extends Effect[
        GetSipMediaApplicationLoggingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
      ]
  object GetProxySession
      extends Effect[
        GetProxySessionRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly
      ]
  object DeletePhoneNumber
      extends Effect[DeletePhoneNumberRequest, AwsError, Unit]
  object ListPhoneNumberOrders
      extends Stream[
        ListPhoneNumberOrdersRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
      ]
  object ListPhoneNumberOrdersPaginated
      extends Effect[
        ListPhoneNumberOrdersRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly
      ]
  object GetSpeakerSearchTask
      extends Effect[
        GetSpeakerSearchTaskRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly
      ]
  object ListVoiceProfiles
      extends Stream[
        ListVoiceProfilesRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly
      ]
  object ListVoiceProfilesPaginated
      extends Effect[
        ListVoiceProfilesRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly
      ]
  object DeleteSipMediaApplication
      extends Effect[DeleteSipMediaApplicationRequest, AwsError, Unit]
  object ListProxySessions
      extends Stream[
        ListProxySessionsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
      ]
  object ListProxySessionsPaginated
      extends Effect[
        ListProxySessionsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly
      ]
  object DeleteVoiceConnectorProxy
      extends Effect[DeleteVoiceConnectorProxyRequest, AwsError, Unit]
  object StartSpeakerSearchTask
      extends Effect[
        StartSpeakerSearchTaskRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly
      ]
  object GetPhoneNumberOrder
      extends Effect[
        GetPhoneNumberOrderRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetPhoneNumberOrderResponse.ReadOnly
      ]
  object UpdateVoiceConnector
      extends Effect[
        UpdateVoiceConnectorRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly
      ]
  object GetSipMediaApplication
      extends Effect[
        GetSipMediaApplicationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly
      ]
  object StopVoiceToneAnalysisTask
      extends Effect[StopVoiceToneAnalysisTaskRequest, AwsError, Unit]
  object UpdateSipMediaApplicationCall
      extends Effect[
        UpdateSipMediaApplicationCallRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly
      ]
  object UpdateVoiceProfile
      extends Effect[
        UpdateVoiceProfileRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly
      ]
  object DeleteVoiceConnectorOrigination
      extends Effect[DeleteVoiceConnectorOriginationRequest, AwsError, Unit]
  object ListPhoneNumbers
      extends Stream[
        ListPhoneNumbersRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly
      ]
  object ListPhoneNumbersPaginated
      extends Effect[
        ListPhoneNumbersRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly
      ]
  object DeleteVoiceConnectorTerminationCredentials
      extends Effect[
        DeleteVoiceConnectorTerminationCredentialsRequest,
        AwsError,
        Unit
      ]
  object UpdatePhoneNumber
      extends Effect[
        UpdatePhoneNumberRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly
      ]
  object UpdateVoiceProfileDomain
      extends Effect[
        UpdateVoiceProfileDomainRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainResponse.ReadOnly
      ]
  object GetVoiceConnectorTerminationHealth
      extends Effect[
        GetVoiceConnectorTerminationHealthRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
      ]
  object GetPhoneNumber
      extends Effect[
        GetPhoneNumberRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetPhoneNumberResponse.ReadOnly
      ]
  object PutVoiceConnectorLoggingConfiguration
      extends Effect[
        PutVoiceConnectorLoggingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
      ]
  object SearchAvailablePhoneNumbers
      extends Stream[
        SearchAvailablePhoneNumbersRequest,
        AwsError,
        E164PhoneNumber
      ]
  object SearchAvailablePhoneNumbersPaginated
      extends Effect[
        SearchAvailablePhoneNumbersRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse.ReadOnly
      ]
  object ListVoiceProfileDomains
      extends Stream[
        ListVoiceProfileDomainsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly
      ]
  object ListVoiceProfileDomainsPaginated
      extends Effect[
        ListVoiceProfileDomainsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly
      ]
  object ListVoiceConnectorTerminationCredentials
      extends Effect[
        ListVoiceConnectorTerminationCredentialsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object UpdateSipMediaApplication
      extends Effect[
        UpdateSipMediaApplicationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationResponse.ReadOnly
      ]
  object GetSipRule extends Effect[GetSipRuleRequest, AwsError, ReadOnly]
  object UpdatePhoneNumberSettings
      extends Effect[UpdatePhoneNumberSettingsRequest, AwsError, Unit]
  object PutSipMediaApplicationAlexaSkillConfiguration
      extends Effect[
        PutSipMediaApplicationAlexaSkillConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
      ]
  object GetVoiceConnectorStreamingConfiguration
      extends Effect[
        GetVoiceConnectorStreamingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
      ]
  object CreateVoiceConnectorGroup
      extends Effect[
        CreateVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly
      ]
  object DeleteProxySession
      extends Effect[DeleteProxySessionRequest, AwsError, Unit]
  object StartVoiceToneAnalysisTask
      extends Effect[
        StartVoiceToneAnalysisTaskRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse.ReadOnly
      ]
  object GetVoiceProfileDomain
      extends Effect[
        GetVoiceProfileDomainRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly
      ]
  object ListSipRules
      extends Stream[
        ListSipRulesRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.SipRule.ReadOnly
      ]
  object ListSipRulesPaginated
      extends Effect[
        ListSipRulesRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly
      ]
  object GetGlobalSettings
      extends Effect[
        Unit,
        AwsError,
        zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListTagsForResourceResponse.ReadOnly
      ]
  object PutVoiceConnectorTermination
      extends Effect[
        PutVoiceConnectorTerminationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly
      ]
  object AssociatePhoneNumbersWithVoiceConnectorGroup
      extends Effect[
        AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object BatchDeletePhoneNumber
      extends Effect[
        BatchDeletePhoneNumberRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly
      ]
  object DisassociatePhoneNumbersFromVoiceConnectorGroup
      extends Effect[
        DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
      ]
  object PutVoiceConnectorTerminationCredentials
      extends Effect[
        PutVoiceConnectorTerminationCredentialsRequest,
        AwsError,
        Unit
      ]
  object CreateSipMediaApplicationCall
      extends Effect[
        CreateSipMediaApplicationCallRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly
      ]
  object GetVoiceProfile
      extends Effect[
        GetVoiceProfileRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly
      ]
  object GetVoiceConnectorLoggingConfiguration
      extends Effect[
        GetVoiceConnectorLoggingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
      ]
  object DeleteVoiceProfileDomain
      extends Effect[DeleteVoiceProfileDomainRequest, AwsError, Unit]
  object DeleteVoiceConnectorGroup
      extends Effect[DeleteVoiceConnectorGroupRequest, AwsError, Unit]
  object PutVoiceConnectorStreamingConfiguration
      extends Effect[
        PutVoiceConnectorStreamingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
      ]
  object GetVoiceConnectorEmergencyCallingConfiguration
      extends Effect[
        GetVoiceConnectorEmergencyCallingConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
      ]
  object DeleteVoiceConnectorTermination
      extends Effect[DeleteVoiceConnectorTerminationRequest, AwsError, Unit]
  object DeleteVoiceConnectorStreamingConfiguration
      extends Effect[
        DeleteVoiceConnectorStreamingConfigurationRequest,
        AwsError,
        Unit
      ]
  object PutVoiceConnectorOrigination
      extends Effect[
        PutVoiceConnectorOriginationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly
      ]
  object StopSpeakerSearchTask
      extends Effect[StopSpeakerSearchTaskRequest, AwsError, Unit]
  object GetPhoneNumberSettings
      extends Effect[
        Unit,
        AwsError,
        zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly
      ]
  object UpdateProxySession
      extends Effect[
        UpdateProxySessionRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly
      ]
  object UpdateGlobalSettings
      extends Effect[UpdateGlobalSettingsRequest, AwsError, Unit]
  object ListVoiceConnectorGroups
      extends Stream[
        ListVoiceConnectorGroupsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
      ]
  object ListVoiceConnectorGroupsPaginated
      extends Effect[
        ListVoiceConnectorGroupsRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly
      ]
  object CreateSipRule
      extends Effect[
        CreateSipRuleRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly
      ]
  object GetVoiceConnectorGroup
      extends Effect[
        GetVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupResponse.ReadOnly
      ]
  object CreateProxySession
      extends Effect[
        CreateProxySessionRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly
      ]
  object GetVoiceConnectorOrigination
      extends Effect[
        GetVoiceConnectorOriginationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly
      ]
  object CreateSipMediaApplication
      extends Effect[
        CreateSipMediaApplicationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly
      ]
  object CreateVoiceProfile
      extends Effect[
        CreateVoiceProfileRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly
      ]
  object ValidateE911Address
      extends Effect[
        ValidateE911AddressRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly
      ]
  object DeleteVoiceConnector
      extends Effect[DeleteVoiceConnectorRequest, AwsError, Unit]
  object BatchUpdatePhoneNumber
      extends Effect[
        BatchUpdatePhoneNumberRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberResponse.ReadOnly
      ]
  object GetSipMediaApplicationAlexaSkillConfiguration
      extends Effect[
        GetSipMediaApplicationAlexaSkillConfigurationRequest,
        AwsError,
        zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ChimeSdkVoice] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ChimeSdkVoice] { rts =>
        zio.ZIO.succeed {
          new ChimeSdkVoice {
            val api: ChimeSdkVoiceAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ChimeSdkVoice = this
            def listSipMediaApplications(
                request: ListSipMediaApplicationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSipMediaApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSipMediaApplicationsPaginated(
                request: ListSipMediaApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly
            ] = proxy(ListSipMediaApplicationsPaginated, request)
            def deleteVoiceProfile(
                request: DeleteVoiceProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteVoiceProfile, request)
            def putVoiceConnectorEmergencyCallingConfiguration(
                request: PutVoiceConnectorEmergencyCallingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
            ] = proxy(PutVoiceConnectorEmergencyCallingConfiguration, request)
            def deleteSipRule(
                request: DeleteSipRuleRequest
            ): IO[AwsError, Unit] = proxy(DeleteSipRule, request)
            def putVoiceConnectorProxy(
                request: PutVoiceConnectorProxyRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyResponse.ReadOnly
            ] = proxy(PutVoiceConnectorProxy, request)
            def createVoiceConnector(request: CreateVoiceConnectorRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateVoiceConnectorResponse.ReadOnly
            ] = proxy(CreateVoiceConnector, request)
            def restorePhoneNumber(request: RestorePhoneNumberRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly
            ] = proxy(RestorePhoneNumber, request)
            def putSipMediaApplicationLoggingConfiguration(
                request: PutSipMediaApplicationLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
            ] = proxy(PutSipMediaApplicationLoggingConfiguration, request)
            def getVoiceConnector(request: GetVoiceConnectorRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly
            ] = proxy(GetVoiceConnector, request)
            def disassociatePhoneNumbersFromVoiceConnector(
                request: DisassociatePhoneNumbersFromVoiceConnectorRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
            ] = proxy(DisassociatePhoneNumbersFromVoiceConnector, request)
            def updateVoiceConnectorGroup(
                request: UpdateVoiceConnectorGroupRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse.ReadOnly
            ] = proxy(UpdateVoiceConnectorGroup, request)
            def listSupportedPhoneNumberCountries(
                request: ListSupportedPhoneNumberCountriesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
            ] = proxy(ListSupportedPhoneNumberCountries, request)
            def getVoiceConnectorProxy(
                request: GetVoiceConnectorProxyRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorProxyResponse.ReadOnly
            ] = proxy(GetVoiceConnectorProxy, request)
            def listVoiceConnectors(
                request: ListVoiceConnectorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVoiceConnectors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVoiceConnectorsPaginated(
                request: ListVoiceConnectorsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly
            ] = proxy(ListVoiceConnectorsPaginated, request)
            def createVoiceProfileDomain(
                request: CreateVoiceProfileDomainRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainResponse.ReadOnly
            ] = proxy(CreateVoiceProfileDomain, request)
            def getVoiceToneAnalysisTask(
                request: GetVoiceToneAnalysisTaskRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly
            ] = proxy(GetVoiceToneAnalysisTask, request)
            def updateSipRule(request: UpdateSipRuleRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateSipRuleResponse.ReadOnly
            ] = proxy(UpdateSipRule, request)
            def listAvailableVoiceConnectorRegions(): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly
            ] = proxy(ListAvailableVoiceConnectorRegions)
            def getVoiceConnectorTermination(
                request: GetVoiceConnectorTerminationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationResponse.ReadOnly
            ] = proxy(GetVoiceConnectorTermination, request)
            def associatePhoneNumbersWithVoiceConnector(
                request: AssociatePhoneNumbersWithVoiceConnectorRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
            ] = proxy(AssociatePhoneNumbersWithVoiceConnector, request)
            def createPhoneNumberOrder(
                request: CreatePhoneNumberOrderRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly
            ] = proxy(CreatePhoneNumberOrder, request)
            def deleteVoiceConnectorEmergencyCallingConfiguration(
                request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteVoiceConnectorEmergencyCallingConfiguration, request)
            def getSipMediaApplicationLoggingConfiguration(
                request: GetSipMediaApplicationLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
            ] = proxy(GetSipMediaApplicationLoggingConfiguration, request)
            def getProxySession(request: GetProxySessionRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetProxySessionResponse.ReadOnly
            ] = proxy(GetProxySession, request)
            def deletePhoneNumber(
                request: DeletePhoneNumberRequest
            ): IO[AwsError, Unit] = proxy(DeletePhoneNumber, request)
            def listPhoneNumberOrders(
                request: ListPhoneNumberOrdersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPhoneNumberOrders, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPhoneNumberOrdersPaginated(
                request: ListPhoneNumberOrdersRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListPhoneNumberOrdersResponse.ReadOnly
            ] = proxy(ListPhoneNumberOrdersPaginated, request)
            def getSpeakerSearchTask(request: GetSpeakerSearchTaskRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly
            ] = proxy(GetSpeakerSearchTask, request)
            def listVoiceProfiles(request: ListVoiceProfilesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.VoiceProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVoiceProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVoiceProfilesPaginated(
                request: ListVoiceProfilesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListVoiceProfilesResponse.ReadOnly
            ] = proxy(ListVoiceProfilesPaginated, request)
            def deleteSipMediaApplication(
                request: DeleteSipMediaApplicationRequest
            ): IO[AwsError, Unit] = proxy(DeleteSipMediaApplication, request)
            def listProxySessions(request: ListProxySessionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProxySessions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProxySessionsPaginated(
                request: ListProxySessionsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly
            ] = proxy(ListProxySessionsPaginated, request)
            def deleteVoiceConnectorProxy(
                request: DeleteVoiceConnectorProxyRequest
            ): IO[AwsError, Unit] = proxy(DeleteVoiceConnectorProxy, request)
            def startSpeakerSearchTask(
                request: StartSpeakerSearchTaskRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly
            ] = proxy(StartSpeakerSearchTask, request)
            def getPhoneNumberOrder(request: GetPhoneNumberOrderRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetPhoneNumberOrderResponse.ReadOnly
            ] = proxy(GetPhoneNumberOrder, request)
            def updateVoiceConnector(request: UpdateVoiceConnectorRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly
            ] = proxy(UpdateVoiceConnector, request)
            def getSipMediaApplication(
                request: GetSipMediaApplicationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly
            ] = proxy(GetSipMediaApplication, request)
            def stopVoiceToneAnalysisTask(
                request: StopVoiceToneAnalysisTaskRequest
            ): IO[AwsError, Unit] = proxy(StopVoiceToneAnalysisTask, request)
            def updateSipMediaApplicationCall(
                request: UpdateSipMediaApplicationCallRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly
            ] = proxy(UpdateSipMediaApplicationCall, request)
            def updateVoiceProfile(request: UpdateVoiceProfileRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateVoiceProfileResponse.ReadOnly
            ] = proxy(UpdateVoiceProfile, request)
            def deleteVoiceConnectorOrigination(
                request: DeleteVoiceConnectorOriginationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteVoiceConnectorOrigination, request)
            def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPhoneNumbers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly
            ] = proxy(ListPhoneNumbersPaginated, request)
            def deleteVoiceConnectorTerminationCredentials(
                request: DeleteVoiceConnectorTerminationCredentialsRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteVoiceConnectorTerminationCredentials, request)
            def updatePhoneNumber(request: UpdatePhoneNumberRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly
            ] = proxy(UpdatePhoneNumber, request)
            def updateVoiceProfileDomain(
                request: UpdateVoiceProfileDomainRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainResponse.ReadOnly
            ] = proxy(UpdateVoiceProfileDomain, request)
            def getVoiceConnectorTerminationHealth(
                request: GetVoiceConnectorTerminationHealthRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
            ] = proxy(GetVoiceConnectorTerminationHealth, request)
            def getPhoneNumber(request: GetPhoneNumberRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetPhoneNumberResponse.ReadOnly
            ] = proxy(GetPhoneNumber, request)
            def putVoiceConnectorLoggingConfiguration(
                request: PutVoiceConnectorLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
            ] = proxy(PutVoiceConnectorLoggingConfiguration, request)
            def searchAvailablePhoneNumbers(
                request: SearchAvailablePhoneNumbersRequest
            ): ZStream[Any, AwsError, E164PhoneNumber] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(SearchAvailablePhoneNumbers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def searchAvailablePhoneNumbersPaginated(
                request: SearchAvailablePhoneNumbersRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse.ReadOnly
            ] = proxy(SearchAvailablePhoneNumbersPaginated, request)
            def listVoiceProfileDomains(
                request: ListVoiceProfileDomainsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVoiceProfileDomains, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVoiceProfileDomainsPaginated(
                request: ListVoiceProfileDomainsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListVoiceProfileDomainsResponse.ReadOnly
            ] = proxy(ListVoiceProfileDomainsPaginated, request)
            def listVoiceConnectorTerminationCredentials(
                request: ListVoiceConnectorTerminationCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
            ] = proxy(ListVoiceConnectorTerminationCredentials, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def updateSipMediaApplication(
                request: UpdateSipMediaApplicationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationResponse.ReadOnly
            ] = proxy(UpdateSipMediaApplication, request)
            def getSipRule(request: GetSipRuleRequest): IO[AwsError, ReadOnly] =
              proxy(GetSipRule, request)
            def updatePhoneNumberSettings(
                request: UpdatePhoneNumberSettingsRequest
            ): IO[AwsError, Unit] = proxy(UpdatePhoneNumberSettings, request)
            def putSipMediaApplicationAlexaSkillConfiguration(
                request: PutSipMediaApplicationAlexaSkillConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
            ] = proxy(PutSipMediaApplicationAlexaSkillConfiguration, request)
            def getVoiceConnectorStreamingConfiguration(
                request: GetVoiceConnectorStreamingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
            ] = proxy(GetVoiceConnectorStreamingConfiguration, request)
            def createVoiceConnectorGroup(
                request: CreateVoiceConnectorGroupRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateVoiceConnectorGroupResponse.ReadOnly
            ] = proxy(CreateVoiceConnectorGroup, request)
            def deleteProxySession(
                request: DeleteProxySessionRequest
            ): IO[AwsError, Unit] = proxy(DeleteProxySession, request)
            def startVoiceToneAnalysisTask(
                request: StartVoiceToneAnalysisTaskRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse.ReadOnly
            ] = proxy(StartVoiceToneAnalysisTask, request)
            def getVoiceProfileDomain(
                request: GetVoiceProfileDomainRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly
            ] = proxy(GetVoiceProfileDomain, request)
            def listSipRules(request: ListSipRulesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.SipRule.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSipRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSipRulesPaginated(request: ListSipRulesRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly
            ] = proxy(ListSipRulesPaginated, request)
            def getGlobalSettings(): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly
            ] = proxy(GetGlobalSettings)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def putVoiceConnectorTermination(
                request: PutVoiceConnectorTerminationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly
            ] = proxy(PutVoiceConnectorTermination, request)
            def associatePhoneNumbersWithVoiceConnectorGroup(
                request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
            ] = proxy(AssociatePhoneNumbersWithVoiceConnectorGroup, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def batchDeletePhoneNumber(
                request: BatchDeletePhoneNumberRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly
            ] = proxy(BatchDeletePhoneNumber, request)
            def disassociatePhoneNumbersFromVoiceConnectorGroup(
                request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
            ] = proxy(DisassociatePhoneNumbersFromVoiceConnectorGroup, request)
            def putVoiceConnectorTerminationCredentials(
                request: PutVoiceConnectorTerminationCredentialsRequest
            ): IO[AwsError, Unit] =
              proxy(PutVoiceConnectorTerminationCredentials, request)
            def createSipMediaApplicationCall(
                request: CreateSipMediaApplicationCallRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly
            ] = proxy(CreateSipMediaApplicationCall, request)
            def getVoiceProfile(request: GetVoiceProfileRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceProfileResponse.ReadOnly
            ] = proxy(GetVoiceProfile, request)
            def getVoiceConnectorLoggingConfiguration(
                request: GetVoiceConnectorLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
            ] = proxy(GetVoiceConnectorLoggingConfiguration, request)
            def deleteVoiceProfileDomain(
                request: DeleteVoiceProfileDomainRequest
            ): IO[AwsError, Unit] = proxy(DeleteVoiceProfileDomain, request)
            def deleteVoiceConnectorGroup(
                request: DeleteVoiceConnectorGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteVoiceConnectorGroup, request)
            def putVoiceConnectorStreamingConfiguration(
                request: PutVoiceConnectorStreamingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
            ] = proxy(PutVoiceConnectorStreamingConfiguration, request)
            def getVoiceConnectorEmergencyCallingConfiguration(
                request: GetVoiceConnectorEmergencyCallingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
            ] = proxy(GetVoiceConnectorEmergencyCallingConfiguration, request)
            def deleteVoiceConnectorTermination(
                request: DeleteVoiceConnectorTerminationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteVoiceConnectorTermination, request)
            def deleteVoiceConnectorStreamingConfiguration(
                request: DeleteVoiceConnectorStreamingConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteVoiceConnectorStreamingConfiguration, request)
            def putVoiceConnectorOrigination(
                request: PutVoiceConnectorOriginationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationResponse.ReadOnly
            ] = proxy(PutVoiceConnectorOrigination, request)
            def stopSpeakerSearchTask(
                request: StopSpeakerSearchTaskRequest
            ): IO[AwsError, Unit] = proxy(StopSpeakerSearchTask, request)
            def getPhoneNumberSettings(): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly
            ] = proxy(GetPhoneNumberSettings)
            def updateProxySession(request: UpdateProxySessionRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.UpdateProxySessionResponse.ReadOnly
            ] = proxy(UpdateProxySession, request)
            def updateGlobalSettings(
                request: UpdateGlobalSettingsRequest
            ): IO[AwsError, Unit] = proxy(UpdateGlobalSettings, request)
            def listVoiceConnectorGroups(
                request: ListVoiceConnectorGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVoiceConnectorGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVoiceConnectorGroupsPaginated(
                request: ListVoiceConnectorGroupsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly
            ] = proxy(ListVoiceConnectorGroupsPaginated, request)
            def createSipRule(request: CreateSipRuleRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly
            ] = proxy(CreateSipRule, request)
            def getVoiceConnectorGroup(
                request: GetVoiceConnectorGroupRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupResponse.ReadOnly
            ] = proxy(GetVoiceConnectorGroup, request)
            def createProxySession(request: CreateProxySessionRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly
            ] = proxy(CreateProxySession, request)
            def getVoiceConnectorOrigination(
                request: GetVoiceConnectorOriginationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly
            ] = proxy(GetVoiceConnectorOrigination, request)
            def createSipMediaApplication(
                request: CreateSipMediaApplicationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateSipMediaApplicationResponse.ReadOnly
            ] = proxy(CreateSipMediaApplication, request)
            def createVoiceProfile(request: CreateVoiceProfileRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.CreateVoiceProfileResponse.ReadOnly
            ] = proxy(CreateVoiceProfile, request)
            def validateE911Address(request: ValidateE911AddressRequest): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly
            ] = proxy(ValidateE911Address, request)
            def deleteVoiceConnector(
                request: DeleteVoiceConnectorRequest
            ): IO[AwsError, Unit] = proxy(DeleteVoiceConnector, request)
            def batchUpdatePhoneNumber(
                request: BatchUpdatePhoneNumberRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberResponse.ReadOnly
            ] = proxy(BatchUpdatePhoneNumber, request)
            def getSipMediaApplicationAlexaSkillConfiguration(
                request: GetSipMediaApplicationAlexaSkillConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse.ReadOnly
            ] = proxy(GetSipMediaApplicationAlexaSkillConfiguration, request)
          }
        }
      }
    }
  }
}
