package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  NullableBoolean,
  SipRuleName,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class UpdateSipRuleRequest(
    sipRuleId: NonEmptyString,
    name: SipRuleName,
    disabled: Optional[NullableBoolean] = Optional.Absent,
    targetApplications: Optional[
      Iterable[zio.aws.chimesdkvoice.model.SipRuleTargetApplication]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest = {
    import UpdateSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest
      .builder()
      .sipRuleId(NonEmptyString.unwrap(sipRuleId): java.lang.String)
      .name(SipRuleName.unwrap(name): java.lang.String)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        targetApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetApplications)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.UpdateSipRuleRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateSipRuleRequest.wrap(buildAwsValue())
}
object UpdateSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdateSipRuleRequest =
      zio.aws.chimesdkvoice.model.UpdateSipRuleRequest(
        sipRuleId,
        name,
        disabled.map(value => value),
        targetApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sipRuleId: NonEmptyString
    def name: SipRuleName
    def disabled: Optional[NullableBoolean]
    def targetApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly]
    ]
    def getSipRuleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(sipRuleId)
    def getName: ZIO[Any, Nothing, SipRuleName] = ZIO.succeed(name)
    def getDisabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getTargetApplications: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly
    ]] = AwsError.unwrapOptionField("targetApplications", targetApplications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest
  ) extends zio.aws.chimesdkvoice.model.UpdateSipRuleRequest.ReadOnly {
    override val sipRuleId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString(impl.sipRuleId())
    override val name: SipRuleName =
      zio.aws.chimesdkvoice.model.primitives.SipRuleName(impl.name())
    override val disabled: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: NullableBoolean)
    override val targetApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipRuleTargetApplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.SipRuleTargetApplication.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest
  ): zio.aws.chimesdkvoice.model.UpdateSipRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
