package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSipMediaApplicationCallResponse(
    sipMediaApplicationCall: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationCall
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse = {
    import UpdateSipMediaApplicationCallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationCall.map(value => value.buildAwsValue())
      )(_.sipMediaApplicationCall)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse
      .wrap(buildAwsValue())
}
object UpdateSipMediaApplicationCallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse =
      zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse(
        sipMediaApplicationCall.map(value => value.asEditable)
      )
    def sipMediaApplicationCall
        : Optional[zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly]
    def getSipMediaApplicationCall: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationCall",
      sipMediaApplicationCall
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse
  ) extends zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly {
    override val sipMediaApplicationCall: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationCall())
      .map(value =>
        zio.aws.chimesdkvoice.model.SipMediaApplicationCall.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse
  ): zio.aws.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse.ReadOnly =
    new Wrapper(impl)
}
