package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  CallingRegion,
  E164PhoneNumber,
  CpsLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Termination(
    cpsLimit: Optional[CpsLimit] = Optional.Absent,
    defaultPhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    callingRegions: Optional[Iterable[CallingRegion]] = Optional.Absent,
    cidrAllowedList: Optional[Iterable[String]] = Optional.Absent,
    disabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.Termination = {
    import Termination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.Termination
      .builder()
      .optionallyWith(cpsLimit.map(value => CpsLimit.unwrap(value): Integer))(
        _.cpsLimit
      )
      .optionallyWith(
        defaultPhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.defaultPhoneNumber)
      .optionallyWith(
        callingRegions.map(value =>
          value.map { item =>
            CallingRegion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.callingRegions)
      .optionallyWith(
        cidrAllowedList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrAllowedList)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.Termination.ReadOnly =
    zio.aws.chimesdkvoice.model.Termination.wrap(buildAwsValue())
}
object Termination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.Termination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.Termination =
      zio.aws.chimesdkvoice.model.Termination(
        cpsLimit.map(value => value),
        defaultPhoneNumber.map(value => value),
        callingRegions.map(value => value),
        cidrAllowedList.map(value => value),
        disabled.map(value => value)
      )
    def cpsLimit: Optional[CpsLimit]
    def defaultPhoneNumber: Optional[E164PhoneNumber]
    def callingRegions: Optional[List[CallingRegion]]
    def cidrAllowedList: Optional[List[String]]
    def disabled: Optional[Boolean]
    def getCpsLimit: ZIO[Any, AwsError, CpsLimit] =
      AwsError.unwrapOptionField("cpsLimit", cpsLimit)
    def getDefaultPhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("defaultPhoneNumber", defaultPhoneNumber)
    def getCallingRegions: ZIO[Any, AwsError, List[CallingRegion]] =
      AwsError.unwrapOptionField("callingRegions", callingRegions)
    def getCidrAllowedList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrAllowedList", cidrAllowedList)
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Termination
  ) extends zio.aws.chimesdkvoice.model.Termination.ReadOnly {
    override val cpsLimit: Optional[CpsLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.cpsLimit())
      .map(value => zio.aws.chimesdkvoice.model.primitives.CpsLimit(value))
    override val defaultPhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultPhoneNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(value)
        )
    override val callingRegions: Optional[List[CallingRegion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.primitives.CallingRegion(item)
          }.toList
        )
    override val cidrAllowedList: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrAllowedList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Termination
  ): zio.aws.chimesdkvoice.model.Termination.ReadOnly = new Wrapper(impl)
}
