package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorStreamingConfigurationRequest(
    voiceConnectorId: NonEmptyString,
    streamingConfiguration: zio.aws.chimesdkvoice.model.StreamingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest = {
    import PutVoiceConnectorStreamingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .streamingConfiguration(streamingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorStreamingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .PutVoiceConnectorStreamingConfigurationRequest(
          voiceConnectorId,
          streamingConfiguration.asEditable
        )
    def voiceConnectorId: NonEmptyString
    def streamingConfiguration
        : zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getStreamingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly
    ] = ZIO.succeed(streamingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val streamingConfiguration
        : zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly =
      zio.aws.chimesdkvoice.model.StreamingConfiguration
        .wrap(impl.streamingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
