package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  E164PhoneNumber,
  Country,
  Integer,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorProxyRequest(
    voiceConnectorId: NonEmptyString128,
    defaultSessionExpiryMinutes: Integer,
    phoneNumberPoolCountries: Iterable[Country],
    fallBackPhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    disabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest = {
    import PutVoiceConnectorProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .defaultSessionExpiryMinutes(
        defaultSessionExpiryMinutes: java.lang.Integer
      )
      .phoneNumberPoolCountries(phoneNumberPoolCountries.map { item =>
        Country.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        fallBackPhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.fallBackPhoneNumber)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyRequest =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyRequest(
        voiceConnectorId,
        defaultSessionExpiryMinutes,
        phoneNumberPoolCountries,
        fallBackPhoneNumber.map(value => value),
        disabled.map(value => value)
      )
    def voiceConnectorId: NonEmptyString128
    def defaultSessionExpiryMinutes: Integer
    def phoneNumberPoolCountries: List[Country]
    def fallBackPhoneNumber: Optional[E164PhoneNumber]
    def disabled: Optional[Boolean]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getDefaultSessionExpiryMinutes: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(defaultSessionExpiryMinutes)
    def getPhoneNumberPoolCountries: ZIO[Any, Nothing, List[Country]] =
      ZIO.succeed(phoneNumberPoolCountries)
    def getFallBackPhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("fallBackPhoneNumber", fallBackPhoneNumber)
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val defaultSessionExpiryMinutes: Integer =
      impl.defaultSessionExpiryMinutes(): Integer
    override val phoneNumberPoolCountries: List[Country] = impl
      .phoneNumberPoolCountries()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.primitives.Country(item)
      }
      .toList
    override val fallBackPhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fallBackPhoneNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(value)
        )
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorProxyRequest.ReadOnly =
    new Wrapper(impl)
}
