package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorEmergencyCallingConfigurationRequest(
    voiceConnectorId: NonEmptyString,
    emergencyCallingConfiguration: zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest = {
    import PutVoiceConnectorEmergencyCallingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .emergencyCallingConfiguration(
        emergencyCallingConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorEmergencyCallingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .PutVoiceConnectorEmergencyCallingConfigurationRequest(
          voiceConnectorId,
          emergencyCallingConfiguration.asEditable
        )
    def voiceConnectorId: NonEmptyString
    def emergencyCallingConfiguration
        : zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getEmergencyCallingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.ReadOnly
    ] = ZIO.succeed(emergencyCallingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val emergencyCallingConfiguration
        : zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration.ReadOnly =
      zio.aws.chimesdkvoice.model.EmergencyCallingConfiguration
        .wrap(impl.emergencyCallingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
