package zio.aws.chimesdkvoice.model
import scala.jdk.CollectionConverters._
sealed trait NotificationTarget {
  def unwrap
      : software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget
}
object NotificationTarget {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget
  ): zio.aws.chimesdkvoice.model.NotificationTarget = value match {
    case software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.EVENT_BRIDGE =>
      val r = EventBridge
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.SNS =>
      val r = SNS
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.SQS =>
      val r = SQS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkvoice.model.NotificationTarget {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget =
      software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.UNKNOWN_TO_SDK_VERSION
  }
  case object EventBridge
      extends zio.aws.chimesdkvoice.model.NotificationTarget {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget =
      software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.EVENT_BRIDGE
  }
  case object SNS extends zio.aws.chimesdkvoice.model.NotificationTarget {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget =
      software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.SNS
  }
  case object SQS extends zio.aws.chimesdkvoice.model.NotificationTarget {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget =
      software.amazon.awssdk.services.chimesdkvoice.model.NotificationTarget.SQS
  }
}
