package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoggingConfiguration(
    enableSIPLogs: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.LoggingConfiguration
      .builder()
      .optionallyWith(enableSIPLogs.map(value => value: java.lang.Boolean))(
        _.enableSIPLogs
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly =
    zio.aws.chimesdkvoice.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.LoggingConfiguration =
      zio.aws.chimesdkvoice.model
        .LoggingConfiguration(enableSIPLogs.map(value => value))
    def enableSIPLogs: Optional[Boolean]
    def getEnableSIPLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableSIPLogs", enableSIPLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.LoggingConfiguration
  ) extends zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly {
    override val enableSIPLogs: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableSIPLogs())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.LoggingConfiguration
  ): zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
