package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSupportedPhoneNumberCountriesResponse(
    phoneNumberCountries: Optional[
      Iterable[zio.aws.chimesdkvoice.model.PhoneNumberCountry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse = {
    import ListSupportedPhoneNumberCountriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse
      .builder()
      .optionallyWith(
        phoneNumberCountries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberCountries)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse
      .wrap(buildAwsValue())
}
object ListSupportedPhoneNumberCountriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse =
      zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse(
        phoneNumberCountries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def phoneNumberCountries: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberCountry.ReadOnly]
    ]
    def getPhoneNumberCountries: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumberCountry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("phoneNumberCountries", phoneNumberCountries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse
  ) extends zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly {
    override val phoneNumberCountries: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberCountry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberCountries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.PhoneNumberCountry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse
  ): zio.aws.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly =
    new Wrapper(impl)
}
