package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NextTokenString
import scala.jdk.CollectionConverters._
final case class ListSipRulesResponse(
    sipRules: Optional[Iterable[zio.aws.chimesdkvoice.model.SipRule]] =
      Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse = {
    import ListSipRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse
      .builder()
      .optionallyWith(
        sipRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipRules)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListSipRulesResponse.wrap(buildAwsValue())
}
object ListSipRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListSipRulesResponse =
      zio.aws.chimesdkvoice.model.ListSipRulesResponse(
        sipRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sipRules: Optional[List[zio.aws.chimesdkvoice.model.SipRule.ReadOnly]]
    def nextToken: Optional[NextTokenString]
    def getSipRules: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SipRule.ReadOnly
    ]] = AwsError.unwrapOptionField("sipRules", sipRules)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse
  ) extends zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly {
    override val sipRules
        : Optional[List[zio.aws.chimesdkvoice.model.SipRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.SipRule.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.NextTokenString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse
  ): zio.aws.chimesdkvoice.model.ListSipRulesResponse.ReadOnly = new Wrapper(
    impl
  )
}
