package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorEmergencyCallingConfigurationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest = {
    import DeleteVoiceConnectorEmergencyCallingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorEmergencyCallingConfigurationRequest(
          voiceConnectorId
        )
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
