package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteSipRuleRequest(sipRuleId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest = {
    import DeleteSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest
      .builder()
      .sipRuleId(NonEmptyString.unwrap(sipRuleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.DeleteSipRuleRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteSipRuleRequest.wrap(buildAwsValue())
}
object DeleteSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.DeleteSipRuleRequest =
      zio.aws.chimesdkvoice.model.DeleteSipRuleRequest(sipRuleId)
    def sipRuleId: NonEmptyString
    def getSipRuleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(sipRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteSipRuleRequest.ReadOnly {
    override val sipRuleId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString(impl.sipRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest
  ): zio.aws.chimesdkvoice.model.DeleteSipRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
