package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePhoneNumberOrderResponse(
    phoneNumberOrder: Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse = {
    import CreatePhoneNumberOrderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse
      .builder()
      .optionallyWith(phoneNumberOrder.map(value => value.buildAwsValue()))(
        _.phoneNumberOrder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse
      .wrap(buildAwsValue())
}
object CreatePhoneNumberOrderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse =
      zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse(
        phoneNumberOrder.map(value => value.asEditable)
      )
    def phoneNumberOrder
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly]
    def getPhoneNumberOrder: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly
    ] = AwsError.unwrapOptionField("phoneNumberOrder", phoneNumberOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse
  ) extends zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly {
    override val phoneNumberOrder
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberOrder())
        .map(value => zio.aws.chimesdkvoice.model.PhoneNumberOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse
  ): zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderResponse.ReadOnly =
    new Wrapper(impl)
}
