package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdatePhoneNumberRequest(
    updatePhoneNumberRequestItems: Iterable[
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest = {
    import BatchUpdatePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest
      .builder()
      .updatePhoneNumberRequestItems(updatePhoneNumberRequestItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberRequest
      .wrap(buildAwsValue())
}
object BatchUpdatePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberRequest =
      zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberRequest(
        updatePhoneNumberRequestItems.map { item =>
          item.asEditable
        }
      )
    def updatePhoneNumberRequestItems: List[
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.ReadOnly
    ]
    def getUpdatePhoneNumberRequestItems: ZIO[Any, Nothing, List[
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.ReadOnly
    ]] = ZIO.succeed(updatePhoneNumberRequestItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest
  ) extends zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberRequest.ReadOnly {
    override val updatePhoneNumberRequestItems: List[
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.ReadOnly
    ] = impl
      .updatePhoneNumberRequestItems()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.UpdatePhoneNumberRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest
  ): zio.aws.chimesdkvoice.model.BatchUpdatePhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
