package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDeletePhoneNumberResponse(
    phoneNumberErrors: Optional[
      Iterable[zio.aws.chimesdkvoice.model.PhoneNumberError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse = {
    import BatchDeletePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse
      .builder()
      .optionallyWith(
        phoneNumberErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse
      .wrap(buildAwsValue())
}
object BatchDeletePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse =
      zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse(
        phoneNumberErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def phoneNumberErrors
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly]]
    def getPhoneNumberErrors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumberErrors", phoneNumberErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse
  ) extends zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly {
    override val phoneNumberErrors: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.PhoneNumberError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse
  ): zio.aws.chimesdkvoice.model.BatchDeletePhoneNumberResponse.ReadOnly =
    new Wrapper(impl)
}
