package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  NullableBoolean,
  E164PhoneNumber,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class AssociatePhoneNumbersWithVoiceConnectorRequest(
    voiceConnectorId: NonEmptyString,
    e164PhoneNumbers: Iterable[E164PhoneNumber],
    forceAssociate: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest = {
    import AssociatePhoneNumbersWithVoiceConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .e164PhoneNumbers(e164PhoneNumbers.map { item =>
        E164PhoneNumber.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(forceAssociate.map(value => value: java.lang.Boolean))(
        _.forceAssociate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest
      .wrap(buildAwsValue())
}
object AssociatePhoneNumbersWithVoiceConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest =
      zio.aws.chimesdkvoice.model
        .AssociatePhoneNumbersWithVoiceConnectorRequest(
          voiceConnectorId,
          e164PhoneNumbers,
          forceAssociate.map(value => value)
        )
    def voiceConnectorId: NonEmptyString
    def e164PhoneNumbers: List[E164PhoneNumber]
    def forceAssociate: Optional[NullableBoolean]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getE164PhoneNumbers: ZIO[Any, Nothing, List[E164PhoneNumber]] =
      ZIO.succeed(e164PhoneNumbers)
    def getForceAssociate: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("forceAssociate", forceAssociate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest
  ) extends zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val e164PhoneNumbers: List[E164PhoneNumber] = impl
      .e164PhoneNumbers()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(item)
      }
      .toList
    override val forceAssociate: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceAssociate())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest
  ): zio.aws.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest.ReadOnly =
    new Wrapper(impl)
}
