package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  VoiceProfileDomainName,
  VoiceProfileDomainDescription,
  Arn,
  NonEmptyString256,
  Iso8601Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VoiceProfileDomainSummary(
    voiceProfileDomainId: Optional[NonEmptyString256] = Optional.Absent,
    voiceProfileDomainArn: Optional[Arn] = Optional.Absent,
    name: Optional[VoiceProfileDomainName] = Optional.Absent,
    description: Optional[VoiceProfileDomainDescription] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileDomainSummary = {
    import VoiceProfileDomainSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileDomainSummary
      .builder()
      .optionallyWith(
        voiceProfileDomainId.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.voiceProfileDomainId)
      .optionallyWith(
        voiceProfileDomainArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.voiceProfileDomainArn)
      .optionallyWith(
        name.map(value =>
          VoiceProfileDomainName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          VoiceProfileDomainDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly =
    zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.wrap(buildAwsValue())
}
object VoiceProfileDomainSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileDomainSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary =
      zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary(
        voiceProfileDomainId.map(value => value),
        voiceProfileDomainArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def voiceProfileDomainId: Optional[NonEmptyString256]
    def voiceProfileDomainArn: Optional[Arn]
    def name: Optional[VoiceProfileDomainName]
    def description: Optional[VoiceProfileDomainDescription]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getVoiceProfileDomainId: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField("voiceProfileDomainId", voiceProfileDomainId)
    def getVoiceProfileDomainArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("voiceProfileDomainArn", voiceProfileDomainArn)
    def getName: ZIO[Any, AwsError, VoiceProfileDomainName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, VoiceProfileDomainDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileDomainSummary
  ) extends zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly {
    override val voiceProfileDomainId: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfileDomainId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
    override val voiceProfileDomainArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceProfileDomainArn())
      .map(value => zio.aws.chimesdkvoice.model.primitives.Arn(value))
    override val name: Optional[VoiceProfileDomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.VoiceProfileDomainName(value)
      )
    override val description: Optional[VoiceProfileDomainDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives
            .VoiceProfileDomainDescription(value)
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceProfileDomainSummary
  ): zio.aws.chimesdkvoice.model.VoiceProfileDomainSummary.ReadOnly =
    new Wrapper(impl)
}
