package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.ValidationResult
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ValidateE911AddressResponse(
    validationResult: Optional[ValidationResult] = Optional.Absent,
    addressExternalId: Optional[String] = Optional.Absent,
    address: Optional[zio.aws.chimesdkvoice.model.Address] = Optional.Absent,
    candidateAddressList: Optional[
      Iterable[zio.aws.chimesdkvoice.model.CandidateAddress]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse = {
    import ValidateE911AddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse
      .builder()
      .optionallyWith(
        validationResult.map(value => ValidationResult.unwrap(value): Integer)
      )(_.validationResult)
      .optionallyWith(addressExternalId.map(value => value: java.lang.String))(
        _.addressExternalId
      )
      .optionallyWith(address.map(value => value.buildAwsValue()))(_.address)
      .optionallyWith(
        candidateAddressList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.candidateAddressList)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ValidateE911AddressResponse
      .wrap(buildAwsValue())
}
object ValidateE911AddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ValidateE911AddressResponse =
      zio.aws.chimesdkvoice.model.ValidateE911AddressResponse(
        validationResult.map(value => value),
        addressExternalId.map(value => value),
        address.map(value => value.asEditable),
        candidateAddressList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def validationResult: Optional[ValidationResult]
    def addressExternalId: Optional[String]
    def address: Optional[zio.aws.chimesdkvoice.model.Address.ReadOnly]
    def candidateAddressList
        : Optional[List[zio.aws.chimesdkvoice.model.CandidateAddress.ReadOnly]]
    def getValidationResult: ZIO[Any, AwsError, ValidationResult] =
      AwsError.unwrapOptionField("validationResult", validationResult)
    def getAddressExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressExternalId", addressExternalId)
    def getAddress
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.Address.ReadOnly] =
      AwsError.unwrapOptionField("address", address)
    def getCandidateAddressList: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.CandidateAddress.ReadOnly
    ]] =
      AwsError.unwrapOptionField("candidateAddressList", candidateAddressList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse
  ) extends zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly {
    override val validationResult: Optional[ValidationResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationResult())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.ValidationResult(value)
        )
    override val addressExternalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addressExternalId())
      .map(value => value: String)
    override val address
        : Optional[zio.aws.chimesdkvoice.model.Address.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.address())
        .map(value => zio.aws.chimesdkvoice.model.Address.wrap(value))
    override val candidateAddressList: Optional[
      List[zio.aws.chimesdkvoice.model.CandidateAddress.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.candidateAddressList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.CandidateAddress.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse
  ): zio.aws.chimesdkvoice.model.ValidateE911AddressResponse.ReadOnly =
    new Wrapper(impl)
}
