package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  VoiceProfileDomainDescription,
  VoiceProfileDomainName,
  NonEmptyString256
}
import scala.jdk.CollectionConverters._
final case class UpdateVoiceProfileDomainRequest(
    voiceProfileDomainId: NonEmptyString256,
    name: Optional[VoiceProfileDomainName] = Optional.Absent,
    description: Optional[VoiceProfileDomainDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest = {
    import UpdateVoiceProfileDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest
      .builder()
      .voiceProfileDomainId(
        NonEmptyString256.unwrap(voiceProfileDomainId): java.lang.String
      )
      .optionallyWith(
        name.map(value =>
          VoiceProfileDomainName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          VoiceProfileDomainDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainRequest
      .wrap(buildAwsValue())
}
object UpdateVoiceProfileDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainRequest =
      zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainRequest(
        voiceProfileDomainId,
        name.map(value => value),
        description.map(value => value)
      )
    def voiceProfileDomainId: NonEmptyString256
    def name: Optional[VoiceProfileDomainName]
    def description: Optional[VoiceProfileDomainDescription]
    def getVoiceProfileDomainId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileDomainId)
    def getName: ZIO[Any, AwsError, VoiceProfileDomainName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, VoiceProfileDomainDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest
  ) extends zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainRequest.ReadOnly {
    override val voiceProfileDomainId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileDomainId())
    override val name: Optional[VoiceProfileDomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.VoiceProfileDomainName(value)
      )
    override val description: Optional[VoiceProfileDomainDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives
            .VoiceProfileDomainDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest
  ): zio.aws.chimesdkvoice.model.UpdateVoiceProfileDomainRequest.ReadOnly =
    new Wrapper(impl)
}
