package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVoiceConnectorResponse(
    voiceConnector: Optional[zio.aws.chimesdkvoice.model.VoiceConnector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse = {
    import UpdateVoiceConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse
      .builder()
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse
      .wrap(buildAwsValue())
}
object UpdateVoiceConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse =
      zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse(
        voiceConnector.map(value => value.asEditable)
      )
    def voiceConnector
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly]
    def getVoiceConnector: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse
  ) extends zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly {
    override val voiceConnector
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnector())
        .map(value => zio.aws.chimesdkvoice.model.VoiceConnector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse
  ): zio.aws.chimesdkvoice.model.UpdateVoiceConnectorResponse.ReadOnly =
    new Wrapper(impl)
}
