package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartSpeakerSearchTaskResponse(
    speakerSearchTask: Optional[zio.aws.chimesdkvoice.model.SpeakerSearchTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse = {
    import StartSpeakerSearchTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse
      .builder()
      .optionallyWith(speakerSearchTask.map(value => value.buildAwsValue()))(
        _.speakerSearchTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse
      .wrap(buildAwsValue())
}
object StartSpeakerSearchTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse =
      zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse(
        speakerSearchTask.map(value => value.asEditable)
      )
    def speakerSearchTask
        : Optional[zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly]
    def getSpeakerSearchTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly
    ] = AwsError.unwrapOptionField("speakerSearchTask", speakerSearchTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse
  ) extends zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly {
    override val speakerSearchTask
        : Optional[zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speakerSearchTask())
        .map(value => zio.aws.chimesdkvoice.model.SpeakerSearchTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse
  ): zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskResponse.ReadOnly =
    new Wrapper(impl)
}
