package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  ClientRequestId,
  NonEmptyString256,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class StartSpeakerSearchTaskRequest(
    voiceConnectorId: NonEmptyString128,
    transactionId: NonEmptyString256,
    voiceProfileDomainId: NonEmptyString256,
    clientRequestToken: Optional[ClientRequestId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest = {
    import StartSpeakerSearchTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .transactionId(NonEmptyString256.unwrap(transactionId): java.lang.String)
      .voiceProfileDomainId(
        NonEmptyString256.unwrap(voiceProfileDomainId): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestId.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskRequest
      .wrap(buildAwsValue())
}
object StartSpeakerSearchTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskRequest =
      zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskRequest(
        voiceConnectorId,
        transactionId,
        voiceProfileDomainId,
        clientRequestToken.map(value => value)
      )
    def voiceConnectorId: NonEmptyString128
    def transactionId: NonEmptyString256
    def voiceProfileDomainId: NonEmptyString256
    def clientRequestToken: Optional[ClientRequestId]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getTransactionId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(transactionId)
    def getVoiceProfileDomainId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileDomainId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestId] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest
  ) extends zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val transactionId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.transactionId())
    override val voiceProfileDomainId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileDomainId())
    override val clientRequestToken: Optional[ClientRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.ClientRequestId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest
  ): zio.aws.chimesdkvoice.model.StartSpeakerSearchTaskRequest.ReadOnly =
    new Wrapper(impl)
}
