package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.FunctionArn
import scala.jdk.CollectionConverters._
final case class SipMediaApplicationEndpoint(
    lambdaArn: Optional[FunctionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint = {
    import SipMediaApplicationEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint
      .builder()
      .optionallyWith(
        lambdaArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.lambdaArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly =
    zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint
      .wrap(buildAwsValue())
}
object SipMediaApplicationEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint =
      zio.aws.chimesdkvoice.model
        .SipMediaApplicationEndpoint(lambdaArn.map(value => value))
    def lambdaArn: Optional[FunctionArn]
    def getLambdaArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("lambdaArn", lambdaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint
  ) extends zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly {
    override val lambdaArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaArn())
      .map(value => zio.aws.chimesdkvoice.model.primitives.FunctionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint
  ): zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly =
    new Wrapper(impl)
}
