package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString
import scala.jdk.CollectionConverters._
final case class RestorePhoneNumberRequest(
    phoneNumberId: SensitiveNonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest = {
    import RestorePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest
      .builder()
      .phoneNumberId(
        SensitiveNonEmptyString.unwrap(phoneNumberId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.RestorePhoneNumberRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.RestorePhoneNumberRequest.wrap(buildAwsValue())
}
object RestorePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.RestorePhoneNumberRequest =
      zio.aws.chimesdkvoice.model.RestorePhoneNumberRequest(phoneNumberId)
    def phoneNumberId: SensitiveNonEmptyString
    def getPhoneNumberId: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest
  ) extends zio.aws.chimesdkvoice.model.RestorePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.phoneNumberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest
  ): zio.aws.chimesdkvoice.model.RestorePhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
