package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorTerminationResponse(
    termination: Optional[zio.aws.chimesdkvoice.model.Termination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse = {
    import PutVoiceConnectorTerminationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse
      .builder()
      .optionallyWith(termination.map(value => value.buildAwsValue()))(
        _.termination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorTerminationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse(
        termination.map(value => value.asEditable)
      )
    def termination: Optional[zio.aws.chimesdkvoice.model.Termination.ReadOnly]
    def getTermination
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.Termination.ReadOnly] =
      AwsError.unwrapOptionField("termination", termination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly {
    override val termination
        : Optional[zio.aws.chimesdkvoice.model.Termination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termination())
        .map(value => zio.aws.chimesdkvoice.model.Termination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationResponse.ReadOnly =
    new Wrapper(impl)
}
