package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorLoggingConfigurationResponse(
    loggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.LoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse = {
    import PutVoiceConnectorLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Optional[zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Optional[zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value =>
          zio.aws.chimesdkvoice.model.LoggingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
