package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.ResultMax
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest = {
    import ListVoiceConnectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceConnectorsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceConnectorsRequest.wrap(buildAwsValue())
}
object ListVoiceConnectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListVoiceConnectorsRequest =
      zio.aws.chimesdkvoice.model.ListVoiceConnectorsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest
  ) extends zio.aws.chimesdkvoice.model.ListVoiceConnectorsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chimesdkvoice.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest
  ): zio.aws.chimesdkvoice.model.ListVoiceConnectorsRequest.ReadOnly =
    new Wrapper(impl)
}
