package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NextTokenString
import scala.jdk.CollectionConverters._
final case class ListProxySessionsResponse(
    proxySessions: Optional[
      Iterable[zio.aws.chimesdkvoice.model.ProxySession]
    ] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse = {
    import ListProxySessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse
      .builder()
      .optionallyWith(
        proxySessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proxySessions)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListProxySessionsResponse.wrap(buildAwsValue())
}
object ListProxySessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListProxySessionsResponse =
      zio.aws.chimesdkvoice.model.ListProxySessionsResponse(
        proxySessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proxySessions
        : Optional[List[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly]]
    def nextToken: Optional[NextTokenString]
    def getProxySessions: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
    ]] = AwsError.unwrapOptionField("proxySessions", proxySessions)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse
  ) extends zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly {
    override val proxySessions
        : Optional[List[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.ProxySession.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.NextTokenString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse
  ): zio.aws.chimesdkvoice.model.ListProxySessionsResponse.ReadOnly =
    new Wrapper(impl)
}
