package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAvailableVoiceConnectorRegionsResponse(
    voiceConnectorRegions: Optional[
      Iterable[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse = {
    import ListAvailableVoiceConnectorRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse
      .builder()
      .optionallyWith(
        voiceConnectorRegions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.voiceConnectorRegionsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse
      .wrap(buildAwsValue())
}
object ListAvailableVoiceConnectorRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse =
      zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse(
        voiceConnectorRegions.map(value => value)
      )
    def voiceConnectorRegions
        : Optional[List[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion]]
    def getVoiceConnectorRegions: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion
    ]] =
      AwsError.unwrapOptionField("voiceConnectorRegions", voiceConnectorRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse
  ) extends zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly {
    override val voiceConnectorRegions
        : Optional[List[zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.VoiceConnectorAwsRegion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse
  ): zio.aws.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse.ReadOnly =
    new Wrapper(impl)
}
