package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{
  NonEmptyString256,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class GetVoiceToneAnalysisTaskRequest(
    voiceConnectorId: NonEmptyString128,
    voiceToneAnalysisTaskId: NonEmptyString256,
    isCaller: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest = {
    import GetVoiceToneAnalysisTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .voiceToneAnalysisTaskId(
        NonEmptyString256.unwrap(voiceToneAnalysisTaskId): java.lang.String
      )
      .isCaller(isCaller: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest
      .wrap(buildAwsValue())
}
object GetVoiceToneAnalysisTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest =
      zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest(
        voiceConnectorId,
        voiceToneAnalysisTaskId,
        isCaller
      )
    def voiceConnectorId: NonEmptyString128
    def voiceToneAnalysisTaskId: NonEmptyString256
    def isCaller: Boolean
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getVoiceToneAnalysisTaskId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceToneAnalysisTaskId)
    def getIsCaller: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isCaller)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest
  ) extends zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val voiceToneAnalysisTaskId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceToneAnalysisTaskId())
    override val isCaller: Boolean = impl.isCaller(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest
  ): zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest.ReadOnly =
    new Wrapper(impl)
}
