package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorTerminationHealthResponse(
    terminationHealth: Optional[zio.aws.chimesdkvoice.model.TerminationHealth] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse = {
    import GetVoiceConnectorTerminationHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse
      .builder()
      .optionallyWith(terminationHealth.map(value => value.buildAwsValue()))(
        _.terminationHealth
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorTerminationHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse =
      zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse(
        terminationHealth.map(value => value.asEditable)
      )
    def terminationHealth
        : Optional[zio.aws.chimesdkvoice.model.TerminationHealth.ReadOnly]
    def getTerminationHealth: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.TerminationHealth.ReadOnly
    ] = AwsError.unwrapOptionField("terminationHealth", terminationHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly {
    override val terminationHealth
        : Optional[zio.aws.chimesdkvoice.model.TerminationHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminationHealth())
        .map(value => zio.aws.chimesdkvoice.model.TerminationHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly =
    new Wrapper(impl)
}
