package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorStreamingConfigurationResponse(
    streamingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.StreamingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse = {
    import GetVoiceConnectorStreamingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse
      .builder()
      .optionallyWith(
        streamingConfiguration.map(value => value.buildAwsValue())
      )(_.streamingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorStreamingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse =
      zio.aws.chimesdkvoice.model
        .GetVoiceConnectorStreamingConfigurationResponse(
          streamingConfiguration.map(value => value.asEditable)
        )
    def streamingConfiguration
        : Optional[zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly]
    def getStreamingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingConfiguration",
      streamingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly {
    override val streamingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.StreamingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamingConfiguration())
      .map(value =>
        zio.aws.chimesdkvoice.model.StreamingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
