package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorOriginationResponse(
    origination: Optional[zio.aws.chimesdkvoice.model.Origination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse = {
    import GetVoiceConnectorOriginationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse
      .builder()
      .optionallyWith(origination.map(value => value.buildAwsValue()))(
        _.origination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorOriginationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse =
      zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse(
        origination.map(value => value.asEditable)
      )
    def origination: Optional[zio.aws.chimesdkvoice.model.Origination.ReadOnly]
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.Origination.ReadOnly] =
      AwsError.unwrapOptionField("origination", origination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly {
    override val origination
        : Optional[zio.aws.chimesdkvoice.model.Origination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origination())
        .map(value => zio.aws.chimesdkvoice.model.Origination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationResponse.ReadOnly =
    new Wrapper(impl)
}
