package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorOriginationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest = {
    import GetVoiceConnectorOriginationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorOriginationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationRequest =
      zio.aws.chimesdkvoice.model
        .GetVoiceConnectorOriginationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorOriginationRequest.ReadOnly =
    new Wrapper(impl)
}
