package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSpeakerSearchTaskResponse(
    speakerSearchTask: Optional[zio.aws.chimesdkvoice.model.SpeakerSearchTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse = {
    import GetSpeakerSearchTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse
      .builder()
      .optionallyWith(speakerSearchTask.map(value => value.buildAwsValue()))(
        _.speakerSearchTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse
      .wrap(buildAwsValue())
}
object GetSpeakerSearchTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse =
      zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse(
        speakerSearchTask.map(value => value.asEditable)
      )
    def speakerSearchTask
        : Optional[zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly]
    def getSpeakerSearchTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly
    ] = AwsError.unwrapOptionField("speakerSearchTask", speakerSearchTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse
  ) extends zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly {
    override val speakerSearchTask
        : Optional[zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speakerSearchTask())
        .map(value => zio.aws.chimesdkvoice.model.SpeakerSearchTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse
  ): zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskResponse.ReadOnly =
    new Wrapper(impl)
}
