package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{Iso8601Timestamp, CallingName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberSettingsResponse(
    callingName: Optional[CallingName] = Optional.Absent,
    callingNameUpdatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse = {
    import GetPhoneNumberSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse
      .builder()
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .optionallyWith(
        callingNameUpdatedTimestamp.map(value =>
          Iso8601Timestamp.unwrap(value): Instant
        )
      )(_.callingNameUpdatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse
      .wrap(buildAwsValue())
}
object GetPhoneNumberSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse =
      zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse(
        callingName.map(value => value),
        callingNameUpdatedTimestamp.map(value => value)
      )
    def callingName: Optional[CallingName]
    def callingNameUpdatedTimestamp: Optional[Iso8601Timestamp]
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
    def getCallingNameUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField(
        "callingNameUpdatedTimestamp",
        callingNameUpdatedTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse
  ) extends zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly {
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chimesdkvoice.model.primitives.CallingName(value))
    override val callingNameUpdatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callingNameUpdatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse
  ): zio.aws.chimesdkvoice.model.GetPhoneNumberSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
