package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGlobalSettingsResponse(
    voiceConnector: Optional[
      zio.aws.chimesdkvoice.model.VoiceConnectorSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse = {
    import GetGlobalSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse
      .builder()
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.wrap(buildAwsValue())
}
object GetGlobalSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse =
      zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse(
        voiceConnector.map(value => value.asEditable)
      )
    def voiceConnector
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly]
    def getVoiceConnector: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse
  ) extends zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly {
    override val voiceConnector: Optional[
      zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceConnector())
      .map(value =>
        zio.aws.chimesdkvoice.model.VoiceConnectorSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse
  ): zio.aws.chimesdkvoice.model.GetGlobalSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
