package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{AreaCode, Country}
import scala.jdk.CollectionConverters._
final case class GeoMatchParams(country: Country, areaCode: AreaCode) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchParams = {
    import GeoMatchParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchParams
      .builder()
      .country(Country.unwrap(country): java.lang.String)
      .areaCode(AreaCode.unwrap(areaCode): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly =
    zio.aws.chimesdkvoice.model.GeoMatchParams.wrap(buildAwsValue())
}
object GeoMatchParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GeoMatchParams =
      zio.aws.chimesdkvoice.model.GeoMatchParams(country, areaCode)
    def country: Country
    def areaCode: AreaCode
    def getCountry: ZIO[Any, Nothing, Country] = ZIO.succeed(country)
    def getAreaCode: ZIO[Any, Nothing, AreaCode] = ZIO.succeed(areaCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchParams
  ) extends zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly {
    override val country: Country =
      zio.aws.chimesdkvoice.model.primitives.Country(impl.country())
    override val areaCode: AreaCode =
      zio.aws.chimesdkvoice.model.primitives.AreaCode(impl.areaCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchParams
  ): zio.aws.chimesdkvoice.model.GeoMatchParams.ReadOnly = new Wrapper(impl)
}
