package zio.aws.chimesdkvoice.model
import scala.jdk.CollectionConverters._
sealed trait GeoMatchLevel {
  def unwrap: software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel
}
object GeoMatchLevel {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel
  ): zio.aws.chimesdkvoice.model.GeoMatchLevel = value match {
    case software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel.COUNTRY =>
      val r = Country
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel.AREA_CODE =>
      val r = AreaCode
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkvoice.model.GeoMatchLevel {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel =
      software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object Country extends zio.aws.chimesdkvoice.model.GeoMatchLevel {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel =
      software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel.COUNTRY
  }
  case object AreaCode extends zio.aws.chimesdkvoice.model.GeoMatchLevel {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel =
      software.amazon.awssdk.services.chimesdkvoice.model.GeoMatchLevel.AREA_CODE
  }
}
