package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorStreamingConfigurationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest = {
    import DeleteVoiceConnectorStreamingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorStreamingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorStreamingConfigurationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
