package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest = {
    import DeleteVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorGroupRequest(voiceConnectorGroupId)
    def voiceConnectorGroupId: NonEmptyString
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
