package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  ClientRequestId,
  VoiceProfileDomainDescription,
  VoiceProfileDomainName
}
import scala.jdk.CollectionConverters._
final case class CreateVoiceProfileDomainRequest(
    name: VoiceProfileDomainName,
    description: Optional[VoiceProfileDomainDescription] = Optional.Absent,
    serverSideEncryptionConfiguration: zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration,
    clientRequestToken: Optional[ClientRequestId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chimesdkvoice.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest = {
    import CreateVoiceProfileDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest
      .builder()
      .name(VoiceProfileDomainName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          VoiceProfileDomainDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .serverSideEncryptionConfiguration(
        serverSideEncryptionConfiguration.buildAwsValue()
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestId.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainRequest
      .wrap(buildAwsValue())
}
object CreateVoiceProfileDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainRequest =
      zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainRequest(
        name,
        description.map(value => value),
        serverSideEncryptionConfiguration.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: VoiceProfileDomainName
    def description: Optional[VoiceProfileDomainDescription]
    def serverSideEncryptionConfiguration
        : zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration.ReadOnly
    def clientRequestToken: Optional[ClientRequestId]
    def tags: Optional[List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, VoiceProfileDomainName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, VoiceProfileDomainDescription] =
      AwsError.unwrapOptionField("description", description)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(serverSideEncryptionConfiguration)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestId] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest
  ) extends zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainRequest.ReadOnly {
    override val name: VoiceProfileDomainName =
      zio.aws.chimesdkvoice.model.primitives.VoiceProfileDomainName(impl.name())
    override val description: Optional[VoiceProfileDomainDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives
            .VoiceProfileDomainDescription(value)
        )
    override val serverSideEncryptionConfiguration
        : zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration.ReadOnly =
      zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration
        .wrap(impl.serverSideEncryptionConfiguration())
    override val clientRequestToken: Optional[ClientRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.ClientRequestId(value)
        )
    override val tags
        : Optional[List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest
  ): zio.aws.chimesdkvoice.model.CreateVoiceProfileDomainRequest.ReadOnly =
    new Wrapper(impl)
}
