package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSipMediaApplicationCallResponse(
    sipMediaApplicationCall: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationCall
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse = {
    import CreateSipMediaApplicationCallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationCall.map(value => value.buildAwsValue())
      )(_.sipMediaApplicationCall)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse
      .wrap(buildAwsValue())
}
object CreateSipMediaApplicationCallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse =
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse(
        sipMediaApplicationCall.map(value => value.asEditable)
      )
    def sipMediaApplicationCall
        : Optional[zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly]
    def getSipMediaApplicationCall: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationCall",
      sipMediaApplicationCall
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse
  ) extends zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly {
    override val sipMediaApplicationCall: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationCall())
      .map(value =>
        zio.aws.chimesdkvoice.model.SipMediaApplicationCall.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse
  ): zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallResponse.ReadOnly =
    new Wrapper(impl)
}
