package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString
import scala.jdk.CollectionConverters._
final case class CandidateAddress(
    streetInfo: Optional[SensitiveNonEmptyString] = Optional.Absent,
    streetNumber: Optional[SensitiveNonEmptyString] = Optional.Absent,
    city: Optional[SensitiveNonEmptyString] = Optional.Absent,
    state: Optional[SensitiveNonEmptyString] = Optional.Absent,
    postalCode: Optional[SensitiveNonEmptyString] = Optional.Absent,
    postalCodePlus4: Optional[SensitiveNonEmptyString] = Optional.Absent,
    country: Optional[SensitiveNonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CandidateAddress = {
    import CandidateAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CandidateAddress
      .builder()
      .optionallyWith(
        streetInfo.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.streetInfo)
      .optionallyWith(
        streetNumber.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.streetNumber)
      .optionallyWith(
        city.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.city)
      .optionallyWith(
        state.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.state)
      .optionallyWith(
        postalCode.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.postalCode)
      .optionallyWith(
        postalCodePlus4.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.postalCodePlus4)
      .optionallyWith(
        country.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.country)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.CandidateAddress.ReadOnly =
    zio.aws.chimesdkvoice.model.CandidateAddress.wrap(buildAwsValue())
}
object CandidateAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CandidateAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CandidateAddress =
      zio.aws.chimesdkvoice.model.CandidateAddress(
        streetInfo.map(value => value),
        streetNumber.map(value => value),
        city.map(value => value),
        state.map(value => value),
        postalCode.map(value => value),
        postalCodePlus4.map(value => value),
        country.map(value => value)
      )
    def streetInfo: Optional[SensitiveNonEmptyString]
    def streetNumber: Optional[SensitiveNonEmptyString]
    def city: Optional[SensitiveNonEmptyString]
    def state: Optional[SensitiveNonEmptyString]
    def postalCode: Optional[SensitiveNonEmptyString]
    def postalCodePlus4: Optional[SensitiveNonEmptyString]
    def country: Optional[SensitiveNonEmptyString]
    def getStreetInfo: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("streetInfo", streetInfo)
    def getStreetNumber: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("streetNumber", streetNumber)
    def getCity: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("city", city)
    def getState: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getPostalCode: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getPostalCodePlus4: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("postalCodePlus4", postalCodePlus4)
    def getCountry: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("country", country)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CandidateAddress
  ) extends zio.aws.chimesdkvoice.model.CandidateAddress.ReadOnly {
    override val streetInfo: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streetInfo())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val streetNumber: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streetNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val city: Optional[SensitiveNonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.city())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
      )
    override val state: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val postalCode: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postalCode())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val postalCodePlus4: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postalCodePlus4())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val country: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.country())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CandidateAddress
  ): zio.aws.chimesdkvoice.model.CandidateAddress.ReadOnly = new Wrapper(impl)
}
