package zio.aws.chimesdkvoice.model
import scala.jdk.CollectionConverters._
sealed trait CallingNameStatus {
  def unwrap
      : software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus
}
object CallingNameStatus {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus
  ): zio.aws.chimesdkvoice.model.CallingNameStatus = value match {
    case software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UNASSIGNED =>
      val r = Unassigned
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UPDATE_IN_PROGRESS =>
      val r = UpdateInProgress
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UPDATE_SUCCEEDED =>
      val r = UpdateSucceeded
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UPDATE_FAILED =>
      val r = UpdateFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkvoice.model.CallingNameStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus =
      software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Unassigned extends zio.aws.chimesdkvoice.model.CallingNameStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus =
      software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UNASSIGNED
  }
  case object UpdateInProgress
      extends zio.aws.chimesdkvoice.model.CallingNameStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus =
      software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UPDATE_IN_PROGRESS
  }
  case object UpdateSucceeded
      extends zio.aws.chimesdkvoice.model.CallingNameStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus =
      software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UPDATE_SUCCEEDED
  }
  case object UpdateFailed
      extends zio.aws.chimesdkvoice.model.CallingNameStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus =
      software.amazon.awssdk.services.chimesdkvoice.model.CallingNameStatus.UPDATE_FAILED
  }
}
