package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutSipMediaApplicationAlexaSkillConfigurationRequest(
    sipMediaApplicationId: NonEmptyString,
    sipMediaApplicationAlexaSkillConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest = {
    import PutSipMediaApplicationAlexaSkillConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .optionallyWith(
        sipMediaApplicationAlexaSkillConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.sipMediaApplicationAlexaSkillConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest
      .wrap(buildAwsValue())
}
object PutSipMediaApplicationAlexaSkillConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .PutSipMediaApplicationAlexaSkillConfigurationRequest(
          sipMediaApplicationId,
          sipMediaApplicationAlexaSkillConfiguration.map(value =>
            value.asEditable
          )
        )
    def sipMediaApplicationId: NonEmptyString
    def sipMediaApplicationAlexaSkillConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration.ReadOnly
    ]
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
    def getSipMediaApplicationAlexaSkillConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationAlexaSkillConfiguration",
      sipMediaApplicationAlexaSkillConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
    override val sipMediaApplicationAlexaSkillConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationAlexaSkillConfiguration())
      .map(value =>
        zio.aws.chimesdkvoice.model.SipMediaApplicationAlexaSkillConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest
  ): zio.aws.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
