package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  OriginationRouteWeight,
  OriginationRoutePriority,
  Port
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OriginationRoute(
    host: Optional[String] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.chimesdkvoice.model.OriginationRouteProtocol] =
      Optional.Absent,
    priority: Optional[OriginationRoutePriority] = Optional.Absent,
    weight: Optional[OriginationRouteWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute = {
    import OriginationRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute
      .builder()
      .optionallyWith(host.map(value => value: java.lang.String))(_.host)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        priority.map(value => OriginationRoutePriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        weight.map(value => OriginationRouteWeight.unwrap(value): Integer)
      )(_.weight)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.OriginationRoute.ReadOnly =
    zio.aws.chimesdkvoice.model.OriginationRoute.wrap(buildAwsValue())
}
object OriginationRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.OriginationRoute =
      zio.aws.chimesdkvoice.model.OriginationRoute(
        host.map(value => value),
        port.map(value => value),
        protocol.map(value => value),
        priority.map(value => value),
        weight.map(value => value)
      )
    def host: Optional[String]
    def port: Optional[Port]
    def protocol: Optional[zio.aws.chimesdkvoice.model.OriginationRouteProtocol]
    def priority: Optional[OriginationRoutePriority]
    def weight: Optional[OriginationRouteWeight]
    def getHost: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("host", host)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.OriginationRouteProtocol
    ] = AwsError.unwrapOptionField("protocol", protocol)
    def getPriority: ZIO[Any, AwsError, OriginationRoutePriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getWeight: ZIO[Any, AwsError, OriginationRouteWeight] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute
  ) extends zio.aws.chimesdkvoice.model.OriginationRoute.ReadOnly {
    override val host: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value => value: String)
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.chimesdkvoice.model.primitives.Port(value))
    override val protocol
        : Optional[zio.aws.chimesdkvoice.model.OriginationRouteProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.chimesdkvoice.model.OriginationRouteProtocol.wrap(value)
        )
    override val priority: Optional[OriginationRoutePriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.OriginationRoutePriority(value)
        )
    override val weight: Optional[OriginationRouteWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.OriginationRouteWeight(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute
  ): zio.aws.chimesdkvoice.model.OriginationRoute.ReadOnly = new Wrapper(impl)
}
